IF EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'CG_FND_VERBA_DOC')
BEGIN
	GOTO FINAL
END

CREATE TABLE [dbo].[CG_FND_VERBA_DOC](
	[CD_EMP] INT NOT NULL,
	[CD_FND_VERBA] INT NOT NULL,
	[CD_DOC] INT NOT NULL,
	[DS_DOC] [varchar](150) NOT NULL,
	[ARQUIVO_DOC] [varbinary](max) NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_DOC] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FND_VERBA] ASC,
	[CD_DOC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

FINAL:
GO

IF NOT (OBJECT_ID('FK_CG_FND_VERBA_DOC_CG_FND_VERBA')) IS NULL
BEGIN
	GOTO FINAL
END
ALTER TABLE [dbo].[CG_FND_VERBA_DOC]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_DOC_CG_FND_VERBA] FOREIGN KEY([CD_FND_VERBA],[CD_EMP])
REFERENCES [dbo].[CG_FND_VERBA] ([CD_FND_VERBA],[CD_EMP])

ALTER TABLE [dbo].[CG_FND_VERBA_DOC] CHECK CONSTRAINT [FK_CG_FND_VERBA_DOC_CG_FND_VERBA]
FINAL:

GO

IF NOT (OBJECT_ID('FK_CG_FND_VERBA_DOC_GLB_USU')) IS NULL
BEGIN
	GOTO FINAL
END

ALTER TABLE [dbo].[CG_FND_VERBA_DOC]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_DOC_GLB_USU] FOREIGN KEY([CD_USU])
REFERENCES [dbo].[GLB_USU] ([CD_USU])

ALTER TABLE [dbo].[CG_FND_VERBA_DOC] CHECK CONSTRAINT [FK_CG_FND_VERBA_DOC_GLB_USU]

FINAL: